/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.settings.network.FirewallRule;
import com.ibm.hwmca.base.settings.network.NetAppFirewallRule;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class FirewallAdmin
implements SettingsErrorIds {
    private HashMap chains = new HashMap();
    private boolean configFilesRestored = false;
    private static final String WEB_PORT = System.getProperty("USING_APACHE_SSL", "false").equals("true") ? "443" : "8080";
    private static final FirewallAdmin instance = new FirewallAdmin();
    private static final String CONFIG_FILENAME = "FirewallSettings.";
    private static final String ALL_IFS_CHAIN_NAME = "ALL-HMC-INPUT";
    private static final String TRACE_MASKD = "XSETFWAD";
    private static final String TRACE_MASKF = "XSETFWAF";
    private static final String TRACE_MASKT = "XSETFWAT";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "FirewallAdmin");

    private FirewallAdmin() {
    }

    public static FirewallAdmin getFirewallAdmin() {
        return instance;
    }

    public void flushFirewallChains() throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.flushFirewallChains");
        Iterator it = this.chains.keySet().iterator();
        while (it.hasNext()) {
            String chainName = (String)it.next();
            this.flushFirewallChain(chainName);
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.flushFirewallChains");
    }

    public void flushNetAppFirewallChains() throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.flushNetAppFirewallChains");
        Iterator it = this.chains.keySet().iterator();
        while (it.hasNext()) {
            String chainName = (String)it.next();
            if (!chainName.endsWith("-NETAPP-INPUT")) continue;
            this.flushFirewallChain(chainName);
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.flushNetAppFirewallChains");
    }

    private void flushFirewallChain(String chainName) throws FirewallAdminException {
        block4: {
            try {
                String[] args = new String[]{"flushFirewallChain.sh", chainName};
                int rc = RootProcess.executeProgram(args);
                if (rc == 0 || rc == 1) {
                    ArrayList rules = (ArrayList)this.chains.get(chainName);
                    if (rules != null) {
                        rules.clear();
                    }
                    break block4;
                }
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
            catch (IOException e) {
                FirewallAdminException exc = new FirewallAdminException(e);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
    }

    public void addFirewallRule(FirewallRule rule) throws FirewallAdminException {
        block7: {
            Trace.trace(TRACE_MASKT, "-> FirewallAdmin.addFirewallRule: rule=" + rule);
            String ifName = rule.getInterfaceName();
            String chainName = null;
            chainName = rule instanceof NetAppFirewallRule ? ifName + "-NETAPP-INPUT" : ifName + "-HMC-INPUT";
            ArrayList<FirewallRule> rules = (ArrayList<FirewallRule>)this.chains.get(chainName);
            if (rules == null) {
                this.createFirewallChain(chainName, ifName);
                rules = new ArrayList<FirewallRule>();
                this.chains.put(chainName, rules);
            }
            String[] args = new String[]{"editFirewallChain.sh", "--append", chainName, rule.getInterfaceName(), rule.getProtocol(), rule.getSourceAddr(), rule.getSourceAddrMask(), rule.getPort()};
            try {
                int rc = RootProcess.executeProgram(args);
                if (rc == 0) {
                    if (rule instanceof NetAppFirewallRule) {
                        String appId = ((NetAppFirewallRule)rule).getAppId();
                        if (!appId.equals("-")) {
                            rules.add(rule);
                        }
                    } else {
                        rules.add(rule);
                    }
                    break block7;
                }
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
            catch (IOException e) {
                FirewallAdminException exc = new FirewallAdminException(e);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.addFirewallRule");
    }

    public void removeFirewallRule(FirewallRule rule) throws FirewallAdminException {
        block5: {
            Trace.trace(TRACE_MASKT, "-> FirewallAdmin.removeFirewallRule: rule=" + rule);
            String ifName = rule.getInterfaceName();
            String chainName = null;
            chainName = rule instanceof NetAppFirewallRule ? ifName + "-NETAPP-INPUT" : ifName + "-HMC-INPUT";
            ArrayList rules = (ArrayList)this.chains.get(chainName);
            if (rules == null) {
                this.createFirewallChain(chainName, ifName);
                rules = new ArrayList();
                this.chains.put(chainName, rules);
            }
            String[] args = new String[]{"editFirewallChain.sh", "--delete", chainName, rule.getInterfaceName(), rule.getProtocol(), rule.getSourceAddr(), rule.getSourceAddrMask(), rule.getPort()};
            try {
                int rc = RootProcess.executeProgram(args);
                if (rc == 0) {
                    if (!rules.remove(rule)) {
                        Trace.trace(TRACE_MASKF, "FirewallAdmin.removeFirewallRule: didn't find rule in list");
                    }
                    break block5;
                }
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                throw exc;
            }
            catch (IOException e) {
                FirewallAdminException exc = new FirewallAdminException(e);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.removeFirewallRule");
    }

    public void addRuleForAllInterfaces(String sourceAddr, String sourceAddrMask, String protocol, String port) throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.addRuleForAllInterfaces");
        ArrayList rules = (ArrayList)this.chains.get(ALL_IFS_CHAIN_NAME);
        if (rules == null) {
            this.createFirewallChain(ALL_IFS_CHAIN_NAME, "");
            rules = new ArrayList();
            this.chains.put(ALL_IFS_CHAIN_NAME, rules);
        }
        String[] args = new String[]{"editFirewallChain.sh", "--insert", ALL_IFS_CHAIN_NAME, "", protocol, sourceAddr, sourceAddrMask, port};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
            Trace.trace(TRACE_MASKF, "added rule successfuly");
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.addRuleForAllInterfaces");
    }

    public void removeRuleForAllInterfaces(String sourceAddr, String sourceAddrMask, String protocol, String port) throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.removeRuleForAllInterfaces");
        ArrayList rules = (ArrayList)this.chains.get(ALL_IFS_CHAIN_NAME);
        if (rules == null) {
            this.createFirewallChain(ALL_IFS_CHAIN_NAME, "");
            rules = new ArrayList();
            this.chains.put(ALL_IFS_CHAIN_NAME, rules);
        }
        String[] args = new String[]{"editFirewallChain.sh", "--delete", ALL_IFS_CHAIN_NAME, "", protocol, sourceAddr, sourceAddrMask, port};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                throw exc;
            }
            Trace.trace(TRACE_MASKF, "deleted rule successfuly");
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.removeRuleForAllInterfaces");
    }

    public List getFirewallRules(String ifName) {
        String chainName = ifName + "-HMC-INPUT";
        ArrayList rules = (ArrayList)this.chains.get(chainName);
        if (rules == null) {
            rules = new ArrayList();
            this.chains.put(chainName, rules);
        }
        return new ArrayList(rules);
    }

    public List getNetAppFirewallRules(String ifName) {
        String chainName = ifName + "-NETAPP-INPUT";
        ArrayList rules = (ArrayList)this.chains.get(chainName);
        if (rules == null) {
            rules = new ArrayList();
            this.chains.put(chainName, rules);
        }
        return new ArrayList(rules);
    }

    private void createFirewallChain(String name, String ifName) throws FirewallAdminException {
        String[] args = new String[]{"createFirewallChain.sh", name, ifName};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0 && rc != 1) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
    }

    private void writeConfigFile(String chainName, ArrayList rules) throws IOException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.writeConfigFile");
        String filename = null;
        try {
            filename = BaseFileControl.getFilePath(CONFIG_FILENAME) + CONFIG_FILENAME + chainName;
        }
        catch (HException e) {
            IOException exc = new IOException("Unable to find location of config file");
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        PrintWriter out = new PrintWriter(new FileOutputStream(filename));
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            NetAppFirewallRule rule = (NetAppFirewallRule)it.next();
            out.print(rule.getAppId());
            out.print("|");
            out.print(rule.getSourceAddr());
            out.print("|");
            out.print(rule.getSourceAddrMask());
            out.print("|");
            out.print(rule.getProtocol());
            out.print("|");
            out.print(rule.getPort());
            out.print("\n");
        }
        out.close();
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.writeConfigFile");
    }

    public void writeConfigFiles() throws IOException {
        if (!this.configFilesRestored) {
            Iterator it = this.chains.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String chainName = (String)entry.getKey();
                ArrayList rules = (ArrayList)entry.getValue();
                if (!chainName.endsWith("-NETAPP-INPUT")) continue;
                this.writeConfigFile(chainName, rules);
            }
        } else {
            Trace.trace(TRACE_MASKF, "FirewallAdmin.writeConfigFiles: config files have been restored.. not going to overwrite the values");
        }
    }

    public List getConfigFilenames() {
        ArrayList<String> filenames = new ArrayList<String>();
        Iterator it = this.chains.keySet().iterator();
        while (it.hasNext()) {
            String chainName = (String)it.next();
            if (!chainName.endsWith("-NETAPP-INPUT")) continue;
            filenames.add(CONFIG_FILENAME + chainName);
        }
        return filenames;
    }

    public void readConfigFile(String ifName, boolean apply) throws IOException, FirewallAdminException {
        ArrayList<NetAppFirewallRule> rules;
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.readConfigFile");
        String chainName = ifName + "-NETAPP-INPUT";
        String filename = null;
        String defaultConfigFilename = null;
        try {
            String filePath = BaseFileControl.getFilePath(CONFIG_FILENAME);
            filename = filePath + CONFIG_FILENAME + chainName;
            defaultConfigFilename = filePath + CONFIG_FILENAME + "default";
        }
        catch (HException e) {
            IOException exc = new IOException("Unable to find location of config file");
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        if (apply) {
            this.createFirewallChain(chainName, ifName);
            this.flushFirewallChain(chainName);
        }
        if ((rules = (ArrayList<NetAppFirewallRule>)this.chains.get(chainName)) == null) {
            rules = new ArrayList<NetAppFirewallRule>();
            this.chains.put(chainName, rules);
        }
        rules.clear();
        File file = new File(filename);
        BufferedReader in = null;
        if (file.exists() && file.canRead()) {
            Trace.trace(TRACE_MASKD, "FirewallAdmin.readConfigFile: found saved config file");
            in = new BufferedReader(new FileReader(file));
        } else {
            Trace.trace(TRACE_MASKD, "FirewallAdmin.readConfigFile: no saved config found");
            file = new File(defaultConfigFilename);
            if (file.exists() && file.canRead()) {
                Trace.trace(TRACE_MASKD, "FirewallAdmin.readConfigFile: found default config");
                in = new BufferedReader(new FileReader(file));
            }
        }
        if (in != null) {
            String line;
            while ((line = in.readLine()) != null) {
                Trace.trace(TRACE_MASKF, "FirewallAdmin: processing line='" + line + "'");
                StringTokenizer st = new StringTokenizer(line, "|");
                String appId = st.nextToken();
                String sourceAddr = st.nextToken();
                String sourceAddrMask = st.nextToken();
                String protocol = st.nextToken();
                String port = st.nextToken();
                NetAppFirewallRule rule = new NetAppFirewallRule(appId, ifName, sourceAddr, sourceAddrMask, protocol, port);
                if (apply) {
                    this.addFirewallRule(rule);
                    if (appId.equals("WebSM.name")) {
                        Trace.trace(TRACE_MASKF, "FirewallAdmin: Adding the special rule for WebSM");
                        try {
                            Properties props = new Properties();
                            props.load(new FileInputStream("/usr/websm/codebase/com/ibm/jcb/resources/JCB.properties"));
                            int startPort = Integer.parseInt(props.getProperty("JC_SUPPLIER_PORT"));
                            int endPort = startPort + Integer.parseInt(props.getProperty("JC_SUPPLIER_PORT_RANGE"));
                            rule = new NetAppFirewallRule("-", rule.getInterfaceName(), rule.getSourceAddr(), rule.getSourceAddrMask(), rule.getProtocol(), startPort + ":" + endPort);
                            this.addFirewallRule(rule);
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, "Failed to add special rule for WebSM");
                            Trace.trace(TRACE_MASKF, e);
                        }
                        continue;
                    }
                    if (!appId.equals("RMC.name")) continue;
                    Trace.trace(TRACE_MASKF, "FirewallAdmin: Adding TCP rule for RMC");
                    rule = new NetAppFirewallRule("-", rule.getInterfaceName(), rule.getSourceAddr(), rule.getSourceAddrMask(), "tcp", rule.getPort());
                    this.addFirewallRule(rule);
                    continue;
                }
                rules.add(rule);
            }
        } else {
            Trace.trace(TRACE_MASKF, "FirewallAdmin: Unable to read saved or default config file");
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.readConfigFile");
    }

    public void restoreBootConfig() throws FirewallAdminException {
        String[] args = new String[]{"restoreFirewallConfig.sh"};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0 && rc != 1) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
    }

    public void setConfigFilesRestored(boolean configFilesRestored) {
        Trace.trace(TRACE_MASKF, "<> FirewallAdmin.setConfigFilesRestored: " + configFilesRestored);
        this.configFilesRestored = configFilesRestored;
    }

    public void enableWebPorts() throws FirewallAdminException {
        this.addRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", WEB_PORT);
        this.addRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", String.valueOf(9960));
    }

    public void disableWebPorts() throws FirewallAdminException {
        this.removeRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", WEB_PORT);
        this.removeRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", String.valueOf(9960));
    }

    public static void main(String[] args) throws Exception {
    }
}

